package com.crihexe.hiddenviewsmind.media;

import com.crihexe.hiddenviewsmind.db.entities.PostEntityManual;
import com.crihexe.hiddenviewsmind.db.mongo.PostingQueueMongo;
import com.crihexe.hiddenviewsmind.db.repositories.PostRepository;
import com.crihexe.hiddenviewsmind.db.repositories.PostingQueueRepository;
import com.crihexe.hiddenviewsmind.dto.Post;
import jakarta.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.List;

@Service
public class PostingQueueService {

    @Value("${media.cache.directory}")
    private String mediaCacheDirectory;

    @Autowired
    private PostingQueueRepository postingQueueRepository;

    @Autowired
    private PostRepository postRepository;

    private Path rootLocation;

    @PostConstruct
    public void init() {
        rootLocation = Paths.get(mediaCacheDirectory);
        try {
            Files.createDirectories(rootLocation);
        } catch (IOException e) {
            throw new RuntimeException("Could not initialize storage location", e);
        }
    }

    public void push(Post post) {
        PostingQueueMongo item = new PostingQueueMongo(post);
    }

    public void pop() {

    }

    public Resource load(String filename) {
        PostingQueueMongo post = postingQueueRepository.findByFilename(filename);

        Path file = mediaCacheService.load(filename);
        return new UrlResource(file.toUri());
    }

    public void markAsPosted() {

    }

    public void cleanupOldFiles() {
        LocalDateTime expiryTime = LocalDateTime.now().minusHours(24);
        List<PostingQueueMongo> oldFiles = postingQueueRepository.findAllByPostedAtBefore(expiryTime);

        oldFiles.forEach(file -> {
            try {
                String filename = file.getFilename();
                PostingQueueMongo item = postingQueueRepository.findByFilename(filename);

                // TODO usa item per salvarlo nel db mysql logs

                Files.deleteIfExists(rootLocation.resolve(file.getFilename()));
                postingQueueRepository.delete(item);
            } catch(IOException e) {
                e.printStackTrace();
            }
        });

    }

    private void store(String filename, byte[] content) {
        try {
            Path destinationFile = this.rootLocation.resolve(Paths.get(filename)).normalize().toAbsolutePath();
            if(!destinationFile.getParent().equals(this.rootLocation.toAbsolutePath())) {
                // TODO exception
                throw new RuntimeException("Invalid path. (previene eventuali path ../ attacks)");
            }
            Files.write(destinationFile, content);
        } catch(IOException e) {
            // TODO
        }
    }

    private void remove(String filename) {

    }

}
